package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerAccountDetailDto;
import cn.com.duiba.kjy.api.params.seller.SellerAcDetailPageQryParams;

import java.util.List;

/**
 * @author zhanghuifeng
 * date 2019-05-20-17:38
 */
@AdvancedFeignClient
public interface RemoteSellerAccDetailService {

    /**
     * 分页查询明细
     * @param param
     * @return
     */
    List<SellerAccountDetailDto> find4page(SellerAcDetailPageQryParams param);

    /**
     * 查询明细总条数
     * @param param 参数
     * @return 总条数
     */
    int count4page(SellerAcDetailPageQryParams param);

    /**
     * 根据销售ID和下级ID集合查询存在的下级ID集合
     * @param sellerId
     * @param subordinateIds
     * @return
     */
    List<Long> findSubordinateIds(Long sellerId, List<Long> subordinateIds);
}
