package cn.com.duiba.kjy.api.remoteservice.reward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.reward.RewardWinnerDto;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-03-15 11:41
 * @descript 活动中奖用户 remoteService
 */
@AdvancedFeignClient
public interface RemoteRewardWinnerApiService {

    /**
     * 获取中奖名单
     * @param activityId 活动id
     * @param pageQuery 分页对象
     * @return 中奖名单
     */
    List<RewardWinnerDto> listWinner(Long activityId, PageQuery pageQuery);

    /**
     * 根据用户id分页查询数据
     * @param liveUserId 直播用户id
     * @param pageQuery 分页数据
     * @return 中奖名单
     */
    List<RewardWinnerDto> findPageByUid(Long liveUserId, PageQuery pageQuery);

    /**
     * 保存中奖用户信息
     * @param rewardWinnerDto 中奖用户信息
     * @return 操作结果
     */
    boolean save(RewardWinnerDto rewardWinnerDto);

    /**
     * 获取中奖人信息
     * @param activityId 活动id
     * @param userId 用户id
     * @return 中奖人信息
     */
    RewardWinnerDto getByActivityIdAndUid(Long activityId, Long userId);

    /**
     * 批量插入
     * @param dtoList 列表
     * @return 插入结果
     */
    int batchInsert(List<RewardWinnerDto> dtoList);
}
