package cn.com.duiba.kjy.api.dto.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售客户列表dto
 * @Author chentiecheng
 * @Date 2020/6/6 4:33 下午
 */
@Data
public class SellerCustomerListDto implements Serializable {
    private static final long serialVersionUID = -7960564277889136484L;
    /**
     * 主键
     */
    private Long id;
    /**
     *
     *最后访问时间
     */
    private Date lastVisitTime;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;
    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 备注名称
     */
    private String remarkName;
    /**
     * 客户访问次数
     */
    private Long visitCount;
    /**
     * 是否为特别关注客户
     */
    private Integer isSpecialCustomer;

    /**
     * 阅读越多的偏好类型
     */
    private String likestReadPreference;
}
