package cn.com.duiba.kjy.api.dto.appvideo;

import lombok.Data;

import java.io.Serializable;

/**
 * 视频模版
 * 2021-08-09
 */
@Data
public class AppVideoTemplateDto implements Serializable {
    private static final long serialVersionUID = 16284880695004645L;

    /**
     *
     * 主键
     */
    private Long id;

    /**
     *
     * 栏目ID
     * 此属性不再提供
     */
    @Deprecated
    private Long classificationId;

    /**
     * 视频类型：1:普通视频 2:动画合成视频
     * @see cn.com.duiba.kjy.api.enums.appvideo.AppVideoTemplateTypeEnum
     */
    private Integer videoType;

    /**
     * 视频标题
     */
    private String videoTitle;

    /**
     * 视频封面地址
     */
    private String videoCoverUrl;

    /**
     * 视频标签
     */
    private String videoTag;

    /**
     * 视频脚本简短描述
     */
    private String shortScript;

    /**
     * 视频时长
     */
    private Integer videoDuration;

    /**
     * 视频权重，越大越靠前
     */
    private Long sortIndex;
}
