package cn.com.duiba.kjy.api.enums.reward;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author wangbinbin
 * @create 2021-03-08 11:41
 * @descript 点对点用户领取奖品状态
 */
@AllArgsConstructor
@Getter
public enum RewardStatusEnum {
    /**
     * 未参与
     */
    NO_JOIN(1, "未参与"),

    /**
     * 已参与
     */
    JOINED(2, "已参与"),

    /**
     * 已开奖
     */
    DRAWN(3, "已开奖"),
    ;

    /**
     * 代码
     */
    private final Integer code;

    /**
     * 代码描述
     */
    private final String description;
}
