package cn.com.duiba.kjy.api.remoteservice.invitationLetter;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.invitationLetter.VisitorInvitationLetterRecordDto;
import cn.com.duiba.kjy.api.params.invitationLetter.VisitorInvitationLetterRecordParam;

import java.util.List;

/**
 * 邀请函记录rpc接口
 * @author 吴文哲
 * @date 2020-02-19 13:50
 **/
@AdvancedFeignClient
public interface RemoteVisitorInvitationLetterRecordService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 邀请函访问记录
     */
    VisitorInvitationLetterRecordDto findById(Long id);

    /**
     * 根据配置id、访客id 获取访问记录
     * @param confId 配置ID
     * @param visitorId 访客userId
     * @return 邀请函访问记录
     */
    VisitorInvitationLetterRecordDto findByConfIdAndVisitorId(Long confId, Long visitorId);

    /**
     * 分页查询
     * @param param 分页参数
     * @return 邀请函访问记录集合
     */
    List<VisitorInvitationLetterRecordDto> findPage(VisitorInvitationLetterRecordParam param);

    /**
     * 新增扫码访问记录
     * @param dto 邀请函访问记录
     * @return 执行结果
     */
    int addViewRecord(VisitorInvitationLetterRecordDto dto);

    /**
     * 更新邀请函访问记录
     * @param dto 邀请函访问记录
     * @return 执行结果
     */
    int updateRecord(VisitorInvitationLetterRecordDto dto);

    /**
     * 批量标记为已读
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchMarkAsRead(List<Long> ids);

    /**
     * 根据配置id 访客id查询列表
     * @param confIds
     * @param visitorIds
     * @return
     */
    List<VisitorInvitationLetterRecordDto> selectByConfIdsAndVisitorIds(List<Long> confIds, List<Long> visitorIds);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键
     * @return 用户访问邀请函记录
     */
    List<VisitorInvitationLetterRecordDto> selectByIds(List<Long> ids);
}
