package cn.com.duiba.kjy.api.enums.sms;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 阿里云短信签名枚举
 * 签名需要申请，通过在阿波罗及本枚举配置方可使用
 * {@link cn.com.duiba.kjy.config.SmsConfig#msgSignMap}
 *
 * @author ZhangJun
 * @date 2021/11/17 11:01 上午
 */
@Getter
@AllArgsConstructor
public enum SmsSignTypeEnum {

    /**
     * 客集集
     */
    KJJ(1, "客集集签名"),

    /**
     * 泰康
     */
    TAIKANG(2, "泰康养老签名"),
    ;

    /**
     * 签名类型
     */
    private final Integer signType;

    /**
     * 签名值
     */
    private final String signDesc;

    private static final Map<Integer, SmsSignTypeEnum> ENUM_MAP;

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SmsSignTypeEnum::getSignType, Function.identity())));
    }

    public static SmsSignTypeEnum getByType(Integer signType) {
        if (Objects.isNull(signType)) {
            return null;
        }

        return ENUM_MAP.get(signType);
    }

}
