package cn.com.duiba.kjy.api.params.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmAbutmentPositionTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhanghuifeng
 * date 2020/12/6-19:01
 */
@Data
public class CrmCustomerAbutmentAddParam implements Serializable {

    private static final long serialVersionUID = 729049123270220736L;

    /**
     * 对接人职位类型，1分公司总经理,2企划总,3培训总,4支公司总经理,5区域总,6机构总,7部经理,8组训,9项目对接人,10其他
     * @see CrmAbutmentPositionTypeEnum
     */
    private Integer abutmentPositionType;

    /**
     * 对接人姓名
     */
    private String abutmentName;

    /**
     * 对接人手机号
     */
    private String phoneNum;

    /**
     * 微信号
     */
    private String wechatNum;

    /**
     * 客户来源，1：陌拜，2：转介绍，3：主动线索
     */
    private Integer customerFrom;
}
