package cn.com.duiba.kjy.api.remoteservice.appvideo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.appvideo.AppVideoFrameDto;

import java.util.List;
import java.util.Map;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-08-11 21:17
 */
@AdvancedFeignClient
public interface RemoteAppVideoFrameApiService {

    /**
     * 通过模板id查询相框
     * @param templateId 模板id
     * @return 相框信息
     */
    List<AppVideoFrameDto> searchByTemplateId(Long templateId);

    /**
     * 统计视频模板关联的相框数量（仅管理后台可用）
     * @param templateIds 视频模板id列表
     * @return 关联的相框数量
     */
    Map<Long, Integer> countFrameByTemplateIds(List<Long> templateIds);

    /**
     * 批量新增相框列表
     * @param frameList 相框列表
     * @return 新增结果
     */
    int batchInsert(List<AppVideoFrameDto> frameList);

    /**
     * 批量删除相框列表
     * @param deleteList 相框列表
     * @return 删除结果
     */
    int batchDelete(List<Long> deleteList);
}
