package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpPageDto;

import java.util.List;

/**
 * 企业后台-驾驶舱页面
 *
 * @author ZhangJun
 * @date 2021/10/27 10:29 上午
 */
@AdvancedFeignClient
public interface RemoteCorpPageService {

    /**
     * 根据公司id和管理员类型查询所有驾驶舱页面
     *
     * @param companyId 公司id
     * @param staffType 管理员类型
     * {@link cn.com.duiba.kjy.api.enums.corp.StaffTypeEnum}
     * @return 页面集合
     */
    List<CorpPageDto> listByCompanyIdAndStaffType(Long companyId, Integer staffType);

    /**
     * 新增页面
     *
     * @param pageDto 页面信息
     * @return 影响的条数
     */
    boolean save(CorpPageDto pageDto);

    /**
     * 更新页面
     *
     * @param pageDto 页面信息
     * @return 影响的条数
     */
    boolean update(CorpPageDto pageDto);

    /**
     * 根据页面主键删除页面信息
     *
     * @param id 页面主键id
     * @return 删除的条数
     */
    boolean deletePageById(Long id);

    /**
     * 更新展示状态
     *
     * @param id        主键id
     * @param hideState 展示状态，0-展示，1-隐藏
     * @return 更新结果
     */
    boolean switchStatus(Long id, Integer hideState);

}
