package cn.com.duiba.kjy.api.remoteservice.grass;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.grass.GrassContentReleaseRecordDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.PageQuery;

/**
 * @author: linjianhui
 * @date: 2020/11/10 16:53
 * @description: 种草素材发布时间设置
 */
@AdvancedFeignClient
public interface RemoteGrassContentReleaseRecordService {

    /**
     * 新增/编辑 种草素材发布时间设置
     * @param dto
     * @return
     */
    Long saveOrUpdate(GrassContentReleaseRecordDto dto);

    /**
     * 根据参数分页查询列表
     * @param pageQuery
     * @return
     */
    Page<GrassContentReleaseRecordDto> selectList(PageQuery pageQuery);

    /**
     * 通过id删除
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

}
