package cn.com.duiba.kjy.api.enums.corp;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 企业后台-公司等级枚举
 *
 * @author ZhangJun
 * @date 2021/10/27 1:41 下午
 */
@Getter
@AllArgsConstructor
public enum CorpCompanyLevelEnum {

    HEAD_COMPANY(1, "总公司"),
    SUB_COMPANY(2, "分公司"),
    BRANCH_COMPANY(3, "中心支公司"),
    ;

    /**
     * 公司等级
     */
    private Integer companyLevel;

    /**
     * 等级描述
     */
    private String desc;

    private static final Map<Integer, CorpCompanyLevelEnum> ENUM_MAP;

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CorpCompanyLevelEnum::getCompanyLevel, Function.identity())));
    }

    public static CorpCompanyLevelEnum getByType(Integer companyLevel) {
        if (Objects.isNull(companyLevel)) {
            return null;
        }

        return ENUM_MAP.get(companyLevel);
    }

}
