package cn.com.duiba.kjy.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.content.SellerNetworkLinkExtDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019-12-21 11:53
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerNetworkLinkExtService {

    /**
     * 根据代理人和内容id更新
     * @param dto
     * @return
     */
    Integer updateBySidAndCid(SellerNetworkLinkExtDto dto);

    /**
     * 根据代理人ids和内容ids查询
     * @param sellerIds
     * @param contentIds
     * @return
     */
    List<SellerNetworkLinkExtDto> listBySidsAndCids(List<Long> sellerIds, List<Long> contentIds);

    /**
     * 根据代理人内容id查询
     * @param scids
     * @return
     */
    List<SellerNetworkLinkExtDto> listByScids(List<Long> scids);

}
