package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpCompanyEmployeeStatDto;

/**
 * 企业公司员工统计信息remote
 * @author zhanghuifeng
 * @date 2021/10/28 11:40
 */
@AdvancedFeignClient
public interface RemoteCorpCompanyEmployeeStatService {

    /**
     * 根据公司查询员工统计信息
     * @param companyId 公司
     * @return 统计信息
     */
    CorpCompanyEmployeeStatDto findByCompanyId(Long companyId);

    /**
     * 增加导入人数
     * @param increaseCount 增加数量（可负数）
     * @param companyId 公司ID
     * @return 更新结果
     */
    Boolean increaseImportCount(Long companyId, Integer increaseCount);

    /**
     * 增加激活人数
     * @param increaseCount 增加数量（可负数）
     * @param companyId 公司ID
     * @return 更新行数
     */
    Boolean increaseActivateCount(Long companyId, Integer increaseCount);
}
