package cn.com.duiba.kjy.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.push.SellerPushInfoDto;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * @author xuzhigang
 * @date 2022/3/28 5:10 下午
 **/
@AdvancedFeignClient
public interface RemoteSellerPushInfoService {

    /**
     * 根据销售ID查询
     * @param sellerId 销售ID
     * @return 推送数据
     */
    SellerPushInfoDto selectBySellerId(Long sellerId);

    /**
     * 根据销售ID，批量查询
     * @param sellerIds 销售ID集合
     * @return 代理人推送数据集合
     */
    List<SellerPushInfoDto> selectBySellerIds(Set<Long> sellerIds);
}
