/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.sms;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SmsSignTypeEnum {
    KJJ(1, "\u5ba2\u96c6\u96c6\u7b7e\u540d"),
    TAIKANG(2, "\u6cf0\u5eb7\u517b\u8001\u7b7e\u540d");

    private final Integer signType;
    private final String signDesc;
    private static final Map<Integer, SmsSignTypeEnum> ENUM_MAP;

    public static SmsSignTypeEnum getByType(Integer signType) {
        if (Objects.isNull(signType)) {
            return null;
        }
        return ENUM_MAP.get(signType);
    }

    public Integer getSignType() {
        return this.signType;
    }

    public String getSignDesc() {
        return this.signDesc;
    }

    private SmsSignTypeEnum(Integer signType, String signDesc) {
        this.signType = signType;
        this.signDesc = signDesc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(SmsSignTypeEnum.values()).collect(Collectors.toMap(SmsSignTypeEnum::getSignType, Function.identity())));
    }
}

