package cn.com.duiba.kjy.api.dto.push;

import lombok.Data;

import java.io.Serializable;

/**
 * 代理人推送数据表
 * @author lizhi
 * @date 2021/12/29 4:21 下午
 */
@Data
public class SellerPushInfoDto implements Serializable {

    private static final long serialVersionUID = -8720898422983826864L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 用户ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 销售员昵称
     */
    private String sellerName;

    /**
     * 渠道类型：1:个微公众号 2:企业应用 3:第三方APP
     * @see cn.com.duiba.kjy.base.api.enums.ProviderChannelEnum
     */
    private Integer channelType;

    /**
     * type=1时是公众号ID，type=2时是企微应用ID，type=3时是第三方appId
     */
    private Long channelBizId;

    /**
     * 推送的用户唯一标识
     */
    private String channelUserKey;

    /**
     * 企业微信的企业ID，仅企业微信用户有值
     */
    private Long workCorpId;
}
