package cn.com.duiba.kjy.api.dto.usercommitrecord;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 访客信息提交记录
 * @author kjj mybatis generator 
 * 2020-02-07
 */
@Data
public class UserCommitRecordDto implements Serializable {
    private static final long serialVersionUID = 15810448474548488L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *访客id,tb_users.id
     * not null default = null
     */
    private Long userId;

    /**
     *
     *访客姓名
     * max length = 20
     * not null default = null
     */
    private String userName;

    /**
     *
     *访客手机号
     * max length = 11
     * not null default = null
     */
    private String phone;

    /**
     *
     *销售员的转载内容表id，对应tb_seller_content
     * not null default = null
     */
    private Long scId;

    /**
     *
     *内容ID，对应tb_content.id
     * not null default = null
     */
    private Long contentId;

    /**
     *
     *销售员ID，对应tb_seller.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *用户访问记录id，对应tb_users_visit.id
     * not null default = null
     */
    private Long visitTableId;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}