package cn.com.duiba.kjy.api.enums.activity;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * 测评枚举
 * 每一个类型对应具体某一项测评，目前使用场景是国寿对接了测评，在数据回传时需要根据不同类型的测评来回传不同数据，后续有类似场景也可以用
 *
 * @author xuzhigang
 * @date 2022/7/19 6:03 下午
 **/
@Getter
@AllArgsConstructor
public enum ActivityTypeEnum {
    SUB_HEALTH(1, "亚健康测评"),

    PENSION(2, "养老金测算"),

    FORTUNE(3, "未来三年财运"),

    INVEST(4, "假如你有一个亿怎么花"),
    ;

    private final int type;

    private final String msg;

    /**
     * 根据活动类型查询支持的事件类型
     * 不同的活动需要回传的事件不一样，先写死在这边吧
     *
     * @param activityType type
     * @return {@link ChinaLifeActivityEventTypeEnum}
     */
    public static List<Integer> getEventTypes(Integer activityType) {
        if (Objects.equals(SUB_HEALTH.getType(), activityType) || Objects.equals(PENSION.getType(), activityType)) {
            return Lists.newArrayList(ChinaLifeActivityEventTypeEnum.VISITOR_JOIN.getType(), ChinaLifeActivityEventTypeEnum.SELLER_FORWARD.getType(), ChinaLifeActivityEventTypeEnum.VISITOR_FORWARD.getType());
        }
        if (Objects.equals(FORTUNE.getType(), activityType) || Objects.equals(INVEST.getType(), activityType)) {
            return Lists.newArrayList(ChinaLifeActivityEventTypeEnum.SELLER_FORWARD.getType(), ChinaLifeActivityEventTypeEnum.VISITOR_JOIN.getType());
        }
        return Collections.emptyList();
    }

}
