package cn.com.duiba.kjy.api.enums.bank.direct.red;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2021/12/21 10:21
 * @description 直接发红包 - 审核状态枚举
 */
@Getter
@AllArgsConstructor
public enum DirectRedCheckStatus {

    TO_CHECK(1, "待审核"),
    PASS(2, "审核通过"),
    REFUSE(3, "审核拒绝"),
    ;

    private static final Map<Integer, DirectRedCheckStatus> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(DirectRedCheckStatus::getStatus, Function.identity()))
    );

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据状态获取枚举
     */
    public static DirectRedCheckStatus getByType(Integer type) {
        return ENUM_MAP.get(type);
    }

}

