package cn.com.duiba.kjy.api.enums.sms;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 阿里云短信模版枚举
 * 模版需要申请，通过在阿波罗及本枚举配置方可使用
 * {@link cn.com.duiba.kjy.config.SmsConfig#msgTemplateMap}
 *
 * @author ZhangJun
 * @date 2021/11/17 11:12 上午
 */
@Getter
@AllArgsConstructor
public enum SmsTemplateTypeEnum {

    /**
     * 太保社群短信验证码模版
     * {@link cn.com.duiba.kjy.api.bean.sms.TaiBaoCommunityVerificationParamBean}
     */
    TAIBAO_COMMUNITY_VERIFICATION(1, "太保社区报名表单短信验证码"),

    /**
     * 报名成功通知短信
     * {@link cn.com.duiba.kjy.api.bean.sms.LinkUrlParamBean}
     */
    APPLY_SUCCESS_NOTICE(2, "报名成功通知短信"),

    /**
     * OTO-销售工作台-登录-短信验证码
     * {@link cn.com.duiba.kjy.api.bean.sms.OtoLoginVerificationParamBean}
     */
    OTO_LOGIN_VERIFICATION(3, "OTO-销售工作台登录短信验证码"),

    /**
     * 跟拍助手登录验证码
     * {@link cn.com.duiba.kjy.api.bean.sms.AppLoginCaptchaBean}
     */
    APP_LOGIN_VERIFICATION(4, "跟拍助手登录验证码"),

    /**
     * OTO-leads-客户分配通知
     */
    OTO_LEADS_ASSIGN_NOTIFY_SELLER(5, "OTO-客户分配通知-销售"),

    /**
     * OTO-leads-push团队销售跟进客户
     */
    OTO_LEADS_PUSH_SELLER_FOLLOW_DIRECTOR(6, "OTO-push团队销售跟进客户通知-总监"),

    /**
     * OTO-会员卡权益-表单提交验证码
     */
    OTO_VIP_CARD_VERIFICATION(7, "OTO-会员卡权益-表单提交验证码"),

    /**
     * OTO-邀约短信发送-邀约短信通知（大清谷）
     */
    OTO_INVITATION_MESSAGE(8, "OTO-邀约-短信通知"),

    /**
     * OTO-邀约短信发送-邀约短信通知
     */
    OTO_INVITATION_MESSAGE_TAIKANG_SY(9, "OTO-邀约-短信通知_泰康_申园"),

    /**
     * OTO-邀约短信发送-邀约短信通知
     */
    OTO_INVITATION_MESSAGE_TAIBAO_PT(10, "OTO-邀约-短信通知_太保_普陀"),

    /**
     * OTO-邀约短信发送-邀约短信通知
     */
    OTO_INVITATION_MESSAGE_TAIBAO_LA(11, "OTO-邀约-短信通知_太保_临安"),
    ;

    /**
     * 模版类型
     */
    private final Integer templateType;

    /**
     * 模版描述
     */
    private final String templateDesc;

    private static final Map<Integer, SmsTemplateTypeEnum> ENUM_MAP;

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SmsTemplateTypeEnum::getTemplateType, Function.identity())));
    }

    public static SmsTemplateTypeEnum getByType(Integer templateType) {
        if (Objects.isNull(templateType)) {
            return null;
        }

        return ENUM_MAP.get(templateType);
    }


}
