package cn.com.duiba.kjy.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.push.EveningPushContentDto;
import cn.com.duiba.kjy.api.dto.push.EveningPushContentExtDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.push.EveningPushSearchParam;

import java.util.List;
import java.util.Set;


/**
 * @author linjianhui
 * @description  新版晚安心语推送
 * @date 2020-08-27 13:43
 */
@AdvancedFeignClient
public interface RemoteEveningPushContentService {


    /**
     * 新增/编辑 晚安心语推送内容
     * @param dto
     * @return
     */
    Long saveOrUpdate(EveningPushContentDto dto);


    /**
     * 通过id删除
     * @param id
     * @return
     */
    Boolean deleteById(Long id);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    EveningPushContentExtDto findById(Long id);

    /**
     * 获取首页banner区夜读文章
     * @return
     */
    EveningPushContentExtDto selectInitEvening();

    /**
     * 查询晚安心语推送列表
     * @param params
     * @return
     */
    Page<EveningPushContentExtDto> selectList(EveningPushSearchParam params);

    /**
     * 批量查询是否是夜读文章
     *
     * @param contentIds 内容id集合
     * @return 夜读id集合
     */
    Set<Long> findByContentIds(List<Long> contentIds);

}
