package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.push.SellerPushSwitchDto;
import cn.com.duiba.kjy.api.enums.push.PushCloseTimeTypeEnum;
import cn.com.duiba.kjy.api.enums.push.PushEnum;

import java.util.List;
import java.util.Set;

/**
 * 推送开关配置服务类
 * @author lizhi
 * @date 2019/6/24 2:58 PM
 */
@AdvancedFeignClient
public interface RemoteSellerPushSwitchService {

    /**
     * 销售员该推送是否关闭
     * @param sellerId 销售员ID
     * @param pushType 推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     * @return true-关闭，false-未关闭
     */
    Boolean isClose(Long sellerId, Integer pushType);

    /**
     * 获取给定销售员中关闭该推送的销售员
     * @param pushType 推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     * @param sellerIds 给定销售员ID集合
     * @return 销售员ID集合
     */
    Set<Long> getCloseSellerIdByPushTypeAndSeller(Integer pushType, List<Long> sellerIds);

    /**
     * 获取销售员关闭的所有推送
     * @param sellerId 销售员ID
     * @return 该销售员关闭的所有推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     */
    Set<Integer> getClosePushTypesBySellerId(Long sellerId);

    /**
     * 获取销售员配置
     * @param sellerId 销售员ID
     * @return 配置信息
     */
    List<SellerPushSwitchDto> getBySellerId(Long sellerId);

    /**
     * 销售员开启/关闭推送
     * @param sellerId 销售员ID
     * @param pushType 推送类型
     * @see cn.com.duiba.kjy.api.enums.push.PushEnum
     * @param pushSwitch 开启/关闭
     * @see cn.com.duiba.kjy.api.enums.push.PushSwitchEnum
     * @return
     */
    Boolean closeOrOpenPush(Long sellerId, Integer pushType, Integer pushSwitch);

    /**
     * 更新关闭推送时间
     * @param sellerId 销售员ID
     * @param pushEnum 推送类型枚举
     * @param timeTypeEnum 时间类型枚举
     * @param closeTime 时间
     * @return 是否成功
     */
    boolean updateCloseTime(Long sellerId, PushEnum pushEnum, PushCloseTimeTypeEnum timeTypeEnum, String closeTime);

    /**
     * 判断openId是否能发送（是否在免打扰期间内）
     * @param openId 微信openId
     * @return true-可以推送，false-不可以推送（在免打扰期间内）
     */
    boolean openIdCanSend(String openId);
}
