package cn.com.duiba.kjy.api.remoteservice.process;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.process.ProcessRoleDto;

import java.util.List;
import java.util.Map;

/**
 * @auther: xiaotian
 * @date: 2020-05-04 14:17
 * @description: 流程审批人remote接口
 */
@AdvancedFeignClient
public interface RemoteProcessRoleService {

    /**
     * 根据角色类型列表，返回对应的map
     * @param typeList
     * @return
     */
    Map<Long,List<ProcessRoleDto>>  getListMapByTypeIds(List<Integer> typeList);

    /**
     * 添加角色
     * @param processRoleDto
     * @return
     */
    boolean save(ProcessRoleDto processRoleDto);

    /**
     * 更新角色
     * @param processRoleDto
     * @return
     */
    boolean update(ProcessRoleDto processRoleDto);

    /**
     * 删除角色
     * @param id
     * @return
     */
    boolean del(Long id);
}
