package cn.com.duiba.kjy.api.dto.articlePrize;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 自定义奖品配置表
* 2020-12-15 17:28:05
*/
@Data
public class ArticleCustomPrizeDto implements Serializable {

    private static final long serialVersionUID = -5886454397532146244L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 销售员id，对应tb_seller.id
    */
    private Long sellerId;

    /**
    * 奖品名称
    */
    private String prizeName;

    /**
    * 奖品图片
    */
    private String prizeImg;

    /**
    * 总库存
    */
    private Integer totalStock;

    /**
    * 已用库存
    */
    private Integer usedStock;

    /**
    * 奖品类型：1-指定中奖人,2-所有 3:指定访问次数
    */
    private Integer customPrizeType;

    /**
    * 访问次数
    */
    private Integer prizeVisitCount;

    /**
    * 状态，1=已开启，0=未开启 -1:删除
    */
    private Integer customStatus;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


}

