package cn.com.duiba.kjy.api.dto.corp;

import lombok.Data;

import java.io.Serializable;

/**
 * 企业版-企业员工表
 *
 * @author kjj mybatis generator
 * 2021-10-27
 */
@Data
public class CorpCompanyEmployeeDto implements Serializable {
    private static final long serialVersionUID = 16353133510285513L;

    /**
     * 主键
     * not null default = null
     */
    private Long id;

    /**
     * 公司ID，tb_corp_company.id
     * not null default = null
     */
    private Long companyId;

    /**
     * 营业部ID，tb_corp_company_dept.id
     * not null default = null
     */
    private Long deptId;

    /**
     * 工号
     * max length = 200
     * not null default = null
     */
    private String jobNumber;

    /**
     * 员工姓名
     * max length = 15
     * not null default =
     */
    private String employeeName;

    /**
     * 手机号
     * max length = 30
     * not null default =
     */
    private String employeePhone;

    /**
     * 职位
     * max length = 128
     * not null default =
     */
    private String jobPost;

    /**
     * 用户ID
     * not null default = null
     */
    private Long userId;

    /**
     * 导入任务ID
     */
    private Long importTaskId;

    /**
     *
     *是否删除，1=已删除，0=未删除
     * not null default = 0
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer logicDeleted;

    /**
     * 百年人寿同步的组织架构
     */
    private String thirdCode;

    /**
     * 百年人寿同步的员工渠道
     */
    private String employeeChannel;

    /**
     * 百年一级code
     */
    private String firstCode;

    /**
     * 百年一级name
     */
    private String firstName;

    /**
     * 百年二级code
     */
    private String secondCode;

    /**
     * 百年二级name
     */
    private String secondName;

    /**
     * 加密的工号 企微对接会使用
     */
    private String encryptedJobNumber;

}