package cn.com.duiba.kjy.api.dto.sellercardv5;

import cn.com.duiba.kjy.api.dto.sellercard.AuthenticationDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 文章底部名片
 * @author 吴文哲
 * @date 2020-03-17 13:52
 **/
@Data
public class SellerCardBottomOfArticleDto implements Serializable {

    private static final long serialVersionUID = 6249548577433742955L;

    /**
     * 名片加密的scid
     */
    private Long scid;

    /**
     *
     *头像区域风格 1:默认 2:专业大屏照
     */
    private Byte avatarStyle;

    /**
     * 代理人名片版本
     */
    private Integer userVersion;


    /**
     * 公司logo图片地址
     */
    private String companyLogo;

    /**
     * 销售员昵称
     */
    private String sellerName;

    /**
     * 销售自定头像
     */
    private String avatar;


    /**
     * 销售员手机号
     */
    private String phoneNumber;

    /**
     * 销售员微信号
     */
    private String wechatNumber;

    /**
     * 微信二维码
     */
    private String wechatQrCode;

    /**
     * 自我介绍
     */
    private String personalIntro;

    /**
     * 名片地址
     */
    private String address;

    /**
     * 地址定位信息 用于前端反序列化
     */
    private String addressLocation;

    /**
     * 从业时长
     */
    private Integer exprLength;

    /**
     * 销售员职位
     */
    private String jobPost;

    /**
     * 名片专业风格头像
     */
    private String professionalAvatar;

    /**
     * 专业风格头像缩略图
     * tb_seller_config 表中 config_key:card_professional_avatar_tnl
     */
    private String professionalAvatarThumbnail;

    /**
     *  大图风格 头像
     */
    private String backgroundAvatar;

    /**
     * 名片背景图 缩略图
     * tb_seller_config 表中 config_key:bg_avatar_tnl
     */
    private String backgroundAvatarThumbnail;

    /**
     *
     *背景色 1:默认 2:商务专业
     */
    private Byte backgroundStyle;

    /**
     * 名片5.0专业认证 由后台配置 并且用户可以决定开启或关闭
     */
    private List<AuthenticationDto> authenticationV5;

    /**
     * 是否为Vip
     */
    private boolean isVip;


    /**
     * 常规头像
     * tb_seller_config 表中 config_key:card_normal_avatar
     */
    private String normalAvatar;

    /**
     * 常规头像缩略图
     * tb_seller_config 表中 config_key:normal_avatar_tnl
     */
    private String normalAvatarThumbnail;

    /**
     * 代理人公司名称
     */
    private String companyName;
    /**
     * 执业证号
     * 中宏定制
     */
    private String licNum;

    /**
     * 第三方自定义的公司名称
     */
    private String customCompanyName;
}
