package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpCompanyDto;
import cn.com.duiba.kjy.api.dto.corp.CorpCompanyEmployeeDto;
import cn.com.duiba.kjy.api.dto.corp.CorpEmployeeSimpleDto;
import cn.com.duiba.kjy.api.params.corp.EmployeePageQryParam;
import cn.com.duiba.kjy.api.params.corp.EmployeeSearchParam;

import java.util.List;

/**
 * 企业版员工
 *
 * @author xuzhigang
 * @date 2021/10/27 1:58 下午
 **/
@AdvancedFeignClient
public interface RemoteCorpCompanyEmployeeService {
    /**
     * 根据user_id查询
     *
     * @param userId 员工id
     * @return 员工信息
     */
    CorpCompanyEmployeeDto findByUserId(Long userId);

    /**
     * 根据userId批量查询
     *
     * @param userIds userId集合
     * @return 用户集合
     */
    List<CorpCompanyEmployeeDto> findByUserIds(List<Long> userIds);

    /**
     * 根据公司id和工号查询
     *
     * @param companyId 公司id
     * @param jobNumber 工号
     * @return 员工信息
     */
    CorpCompanyEmployeeDto findByCompanyIdAndJobNumber(Long companyId, String jobNumber);

    /**
     * 根据公司id和加密工号查询
     *
     * @param companyId 公司id
     * @param encryptedJobNumber 加密工号
     * @return 员工信息
     */
    CorpCompanyEmployeeDto findByCompanyIdAndEncryptedJobNumber(Long companyId, String encryptedJobNumber);

    /**
     * 更新
     *
     * @param dto 员工信息
     * @return 执行结果
     */
    int update(CorpCompanyEmployeeDto dto);

    /**
     * 新增
     *
     * @param dto 员工
     * @return 执行结果
     */
    int insert(CorpCompanyEmployeeDto dto);

    /**
     * 逻辑删除
     *
     * @param id 主键id
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 分页查询企业员工信息（后台专用）
     * @param param 分页查询参数
     * @return 列表
     */
    List<CorpCompanyEmployeeDto> page4backend(EmployeePageQryParam param);

    /**
     * 根据营业部ID查询员工数量（后台专用）
     * @param deptId 营业部ID
     * @return 员工数量
     */
    int count4backend(Long deptId);

    /**
     * 判断当前营业部下是否有员工
     * @param deptId 营业部ID
     * @return 是否存在员工
     */
    Boolean existEmployee(Long deptId);

    /**
     * 根据公司ID和工号集合查询员工列表（包含已删除）
     * @param companyId     公司ID
     * @param jobNumberList 工号集合
     * @return 员工列表
     */
    List<CorpCompanyEmployeeDto> listByCompanyIdAndJobNumbers(Long companyId, List<String> jobNumberList);

    /**
     * 根据公司ID和手机号集合查询员工列表（包含已删除）
     * @param companyId     公司ID
     * @param phoneList 手机号集合
     * @return 员工列表
     */
    List<CorpCompanyEmployeeDto> listByCompanyIdAndPhones(Long companyId, List<String> phoneList);

    /**
     * 批量插入
     * @param list 数据
     * @return 插入条数
     */
    int batchInsert(List<CorpCompanyEmployeeDto> list);

    /**
     * 批量更新删除状态
     * @param logicDeleted 是否删除 {@link cn.com.duiba.kjy.api.enums.DeletedEnum}
     * @param idList 员工ID集合
     * @return 更新行数
     */
    int updateDeletedState(Integer logicDeleted, List<Long> idList);

    /**
     * 批量更新
     * @param list 更新数据
     * @return 更新行数
     */
    int batchUpdate(List<CorpCompanyEmployeeDto> list);

    /**
     * 查询员工信息(只返回一条未删除数据)
     * @param param 查询参数
     * @return 员工信息
     */
    CorpCompanyEmployeeDto searchOne(EmployeeSearchParam param);

    /**
     * 根据公司ID和员工名称es搜索
     * @param employeeName 员工姓名
     * @param companyId  公司ID
     * @return 员工列表
     */
    List<CorpEmployeeSimpleDto> esSearch(String employeeName, Long companyId);

    /**
     * 激活 绑定userId  更新会员有效期（不更新代理人姓名）
     *
     * @deprecated 后续使用 {@link #activateV2}
     * @param userId 用户id
     * @param sellerId 销售id
     * @param corpCompanyEmployeeDto 待绑定的员工信息
     * @param corpCompanyDto 待绑定的公司信息
     * @return true-激活成功 false-激活失败
     */
    @Deprecated
    boolean activate(Long userId, Long sellerId, CorpCompanyEmployeeDto corpCompanyEmployeeDto, CorpCompanyDto corpCompanyDto);

    /**
     * 激活 绑定userId  更新会员有效期
     *
     * @param userId 用户id
     * @param sellerId 销售id
     * @param corpCompanyEmployeeDto 待绑定的员工信息
     * @param corpCompanyDto 待绑定的公司信息
     * @param needUpdateSellerName 是否需要更新代理人姓名
     * @return true-激活成功 false-激活失败
     */
    boolean activateV2(Long userId, Long sellerId, CorpCompanyEmployeeDto corpCompanyEmployeeDto, CorpCompanyDto corpCompanyDto, boolean needUpdateSellerName);

    /**
     * 根据员工ID查询
     * @param id 员工ID
     * @return 员工信息
     */
    CorpCompanyEmployeeDto findById(Long id);
}
