package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpImportTaskDto;
import cn.com.duiba.kjy.api.params.corp.CorpImportTaskParam;

import java.util.List;

/**
 * 企业后台导入任务remote
 */
@AdvancedFeignClient
public interface RemoteCorpImportTaskService {
    /**
     * 根据id查询
     * @param id 任务ID
     * @return 任务信息
     */
    CorpImportTaskDto selectOne(Long id);

    /**
     * 分页查询列表(企业后台专用)
     * @param param 查询参数
     * @return 列表
     */
    List<CorpImportTaskDto> page4backend(CorpImportTaskParam param);

    /**
     * 更新
     * @param dto
     * @return 更新结果
     */
    Boolean update(CorpImportTaskDto dto);

    /**
     * 条件查询记录的总记录数(企业后台专用)
     * @param param 查询参数
     * @return 条数
     */
    Integer count4backend(CorpImportTaskParam param);

    /**
     * 新增
     * @param pojo 插入数据
     * @return 任务ID
     */
    Long insert(CorpImportTaskDto pojo);

}