package cn.com.duiba.kjy.api.remoteservice.reward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.reward.RewardVideoDto;
import cn.com.duiba.kjy.api.dto.reward.RewardVideoInfoDto;
import cn.com.duiba.kjy.api.dto.reward.RewardVideoListDto;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-03-08 15:12
 * @descript 点对点视频 remoteService
 */
@AdvancedFeignClient
public interface RemoteRewardVideoApiService {

    /**
     * 点对点抽奖-新增备选视频
     *
     * @param rewardVideoDto 备选视频
     * @return 视频id
     */
    Long addVideo(RewardVideoDto rewardVideoDto);

    /**
     * 点对点抽奖-删除备选视频
     *
     * @param videoId 备选视频
     * @return 视频id
     */
    boolean deleteVideo(Long videoId);

    /**
     * 点对点抽奖-编辑备选视频
     *
     * @param rewardVideoDto 视频参数
     * @return true成功 false失败
     */
    boolean editVideo(RewardVideoDto rewardVideoDto);

    /**
     * 获取备选视频详情
     *
     * @param videoId 视频id
     * @return 视频详情
     */
    RewardVideoDto getVideoInfo(Long videoId);

    /**
     * 统计备选视频总数（仅管理端可用）
     *
     * @return 选视频总数
     */
    long countListVideo4Mng();

    /**
     * 分页获取备选视频详情
     * @param pageQuery 视频查询参数
     * @return 分页结果
     */
    List<RewardVideoDto> listVideo(PageQuery pageQuery);
}
