package cn.com.duiba.kjy.api.constant;

import cn.com.duiba.kjy.api.enums.OATypeEnum;

/**
 * 微信发送消息-事件类型
 * @Auther: Tt(yehuawei)
 * @Date: 2019/7/3 0003 16:17
 */
public enum WeChatSendEventEnum {
    USER_IN_EVENT("USER_FIRST_IN_CHAT_PAGE",OATypeEnum.CONTENT_MAIN_OA,"客户首次进入本次会话聊天页"),
    USER_SEND_EVENT("USER_SEND_MESSAGE",OATypeEnum.CONTENT_MAIN_OA,"客户在本次会话中发送消息"),
    SELLER_SEND_EVENT("SELLER_SEND_EVENT",OATypeEnum.MP,"代理人留言，客户在小程序上接收提醒"),
    ;

    /**
     * 事件
     */
    private String event;
    /**
     * 负责推送该事件消息的微信oa类型
     */
    private OATypeEnum oaTypeEnum;
    /**
     * 描述
     */
    private String desc;

    WeChatSendEventEnum(String event, OATypeEnum oaTypeEnum, String desc) {
        this.event = event;
        this.oaTypeEnum = oaTypeEnum;
        this.desc = desc;
    }

    public static WeChatSendEventEnum byEvent(String event){
        for (WeChatSendEventEnum weChatSendEventEnum:values()){
            if (event.equals(weChatSendEventEnum.getEvent())){
                return weChatSendEventEnum;
            }
        }
        return null;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public OATypeEnum getOaTypeEnum() {
        return oaTypeEnum;
    }

    public void setOaTypeEnum(OATypeEnum oaTypeEnum) {
        this.oaTypeEnum = oaTypeEnum;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
