package cn.com.duiba.kjy.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.tag.ItemTagExtDto;
import cn.com.duiba.kjy.api.dto.tag.ItemTagDto;

import java.util.List;
import java.util.Map;

/**
 * item和标签关联关系service
 * @author zhanghuifeng
 * date 2019-04-11-15:11
 */
@AdvancedFeignClient
public interface RemoteItemTagService {

    /**
     * 根据标签集合获取存在的标签集合
     * @param tagIds
     * @return
     */
    List<Long> findExitTagIdsByTagIds(List<Long> tagIds);

    Map<Long/*contentId*/, Map<Integer/*level*/, List<ItemTagExtDto>>> findTagByItemIds(List<Long> itemIdList);
	
	/**
     * 根据itemId集合获取
     * @param itemIds
     * @param itemType @see TagItemTypeEnum
     * @return
     */
    List<ItemTagDto> findByItemIds(List<Long> itemIds, Integer itemType);

}
