/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.seller;

import java.util.Objects;

public enum SellerSpSwitchEnum {
    SITE_SALE_SWITCH_ON(SellerSpPositionEnum.SITE_SALE.getCode(), switchEnum.ON.getCode(), "\u6d7c\u6c36\u6522\u9417\u89c4\u6f48\u5bee\ufffd\u935a\ufffd"),
    SITE_SALE_SWITCH_OFF(SellerSpPositionEnum.SITE_SALE.getCode(), switchEnum.OFF.getCode(), "\u6d7c\u6c36\u6522\u9417\u89c4\u6f48\u934f\u62bd\u68f4"),
    IMPORTANT_FIGURE_SWITCH_ON(SellerSpPositionEnum.IMPORTANT_FIGURE.getCode(), switchEnum.ON.getCode(), "\u95b2\u5d88\ue6e6\u947a\u509c\u5063\u7039\u3221\u57db\u5bee\ufffd\u935a\ufffd"),
    IMPORTANT_FIGURE_SWITCH_OFF(SellerSpPositionEnum.IMPORTANT_FIGURE.getCode(), switchEnum.OFF.getCode(), "\u95b2\u5d88\ue6e6\u947a\u509c\u5063\u7039\u3221\u57db\u934f\u62bd\u68f4"),
    ENOUGH_COMMISSION_SWITCH_ON(SellerSpPositionEnum.ENOUGH_COMMISSION.getCode(), switchEnum.ON.getCode(), "\u5a4a\uffe0\ue582\u6769\u65be\u5251\u9417\u89c4\u6f48\u5bee\ufffd\u935a\ufffd"),
    ENOUGH_COMMISSION_SWITCH_OFF(SellerSpPositionEnum.ENOUGH_COMMISSION.getCode(), switchEnum.OFF.getCode(), "\u5a4a\uffe0\ue582\u6769\u65be\u5251\u9417\u89c4\u6f48\u934f\u62bd\u68f4");

    private Integer position;
    private Integer switchValue;
    private String desc;

    private SellerSpSwitchEnum(Integer position, Integer switchValue, String desc) {
        this.position = position;
        this.switchValue = switchValue;
        this.desc = desc;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getDesc() {
        return this.desc;
    }

    public static SellerSpSwitchEnum getByPositionAndValue(int position, int switchValue) {
        for (SellerSpSwitchEnum c : SellerSpSwitchEnum.values()) {
            if (!Objects.equals(c.getPosition(), position) || !Objects.equals(c.getSwitchValue(), switchValue)) continue;
            return c;
        }
        return null;
    }

    public static int getSwitchValueByPositionAndDBValue(int position, Integer dBValue) {
        if (Objects.isNull(dBValue)) {
            return switchEnum.OFF.getCode();
        }
        return dBValue >> position - 1 & 1;
    }

    public Integer getSwitchValue() {
        return this.switchValue;
    }

    public static enum SellerSpPositionEnum {
        SITE_SALE(1, "\u6d7c\u6c36\u6522\u9417\u89c4\u6f48"),
        IMPORTANT_FIGURE(2, "\u95b2\u5d88\ue6e6\u947a\u509c\u5063\u7039\u3221\u57db"),
        ENOUGH_COMMISSION(3, "\u5a4a\uffe0\ue582\u6769\u65be\u5251\u9417\u89c4\u6f48");

        private Integer code;
        private String desc;

        public Integer getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        private SellerSpPositionEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    public static enum switchEnum {
        ON(1, "\u5bee\ufffd\u935a\ufffd"),
        OFF(0, "\u934f\u62bd\u68f4");

        private Integer code;
        private String desc;

        public Integer getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        private switchEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }
}

