/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.constant.UserRoleEnum;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class PrivateChatSessionUtil {
    private static final String SEPARATOR = "&";
    private static final String PRIVATE_CHAT_KEY = "hMz1t^neF1Atwt%r";

    public static String createSessionId(Integer currentRole, Long mineRoleId, Long anotherId) {
        switch (UserRoleEnum.getByRole(currentRole)) {
            case USER: {
                return PrivateChatSessionUtil.createSessionId(mineRoleId, anotherId);
            }
            case SELLER: {
                return PrivateChatSessionUtil.createSessionId(anotherId, mineRoleId);
            }
        }
        throw new IllegalArgumentException("unknow user role.");
    }

    public static String createSessionId(Long userId, Long sellerId) {
        String mingwenSessionId = PrivateChatSessionUtil.getMingwenSessionId(userId, sellerId);
        return PrivateChatSessionUtil.encode(mingwenSessionId);
    }

    public static Long getAnotherId(Long currentRoleId, String sessionId) {
        List ids;
        String mwSessionId = PrivateChatSessionUtil.decode(sessionId);
        String[] strs = mwSessionId.split(SEPARATOR);
        if (strs.length == (ids = Arrays.asList(strs).stream().map(Long::valueOf).filter(id -> !currentRoleId.equals(id)).collect(Collectors.toList())).size()) {
            throw new IllegalArgumentException("current user don't belong this chat session.");
        }
        return (Long)ids.get(0);
    }

    protected static String getMingwenSessionId(Long userId, Long sellerId) {
        StringBuilder sb = new StringBuilder();
        sb.append(sellerId).append(SEPARATOR).append(userId);
        return sb.toString();
    }

    public static String decode(String miwenSessionId) {
        return BlowfishUtils.decryptBlowfish((String)miwenSessionId, (String)PRIVATE_CHAT_KEY);
    }

    public static String encode(String mingwenSessionId) {
        return BlowfishUtils.encryptBlowfish((String)mingwenSessionId, (String)PRIVATE_CHAT_KEY);
    }
}

