package cn.com.duiba.kjy.liveaward.center.api.exception;


import cn.com.duiba.kjy.livecenter.api.bean.ErrorCodeInterface;

/**
 * Created by dugq on 2020-03-25.
 */
public enum ErrorCode implements ErrorCodeInterface {
    // 99 系统级别
    SYSTEM_ERROR("999999","系统错误"),
    ILLEGAL_ID("990001", "ID非法"),
    NOT_LOGIN("990002","未登陆"),
    PARAM_ERROR("990003","参数错误"),
    NO_PERMISSION("990004","没有权限"),
    NOT_AGENT("990005","不是代理人"),
    NO_LIVE("9900025","未指定直播间"),
    SYSTEM_BUSY("9900026","系统繁忙，请稍后重试"),
    TOO_BUSY("9900027","操作过于频繁"),

    // 10 公司团队
    AGENT_EXIST("100001","你已经加入团队,请先回到主页退出"),
    LIVE_USER_NOT_EXIST("100002","直播用户不存在"),
    TEAM_HAS_ALREADY_EXISTS("100003","团队已经存在了"),
    ADMIN_CAN_NOT_JOIN_OTHER_TEAM("100004","管理员不能加入其它公司团队"),
    TEAM_NOT_EXISTS("100005","团队已解散无法加入"),
    COMPANY_NOT_EXISTS("100006","直播间公司不存在"),


    // 11 直播
    LIVE_NOT_FIND("110001", "直播未找到"),
    LIVE_STREAM_PUSH_NOT_FIND("110002", "推流未找到"),
    LIVE_OPEN_FAIL("110003", "开始直播失败"),
    LIVE_CLOSE_FAIL("110004", "结束直播失败"),
    LIVE_END("110005","直播已经结束"),
    OLNY_ADMIN_CAN_CLOSE("110006","只有管理员能结束直播"),
    OTHER_LIVE_IS_OPENING("110007","已有直播正在进行中"),
    SAVE_OR_UPDATE_BEAUTIFY_FAIL("110008","保存美颜配置失败"),
    QUESTION_NOT_CONFIG("110009","你好像忘记配置“互动问题”了哦"),
    MAX_RED_PACKAGE_NOT_CONFIG("110010","你好像忘记配置“单场红包限额”了哦"),
    LOTTERY_NOT_CONFIG("110011","你好像忘记配置“抽奖福利”了哦"),

    //12 管理员直播配置
    LIVE_STATISTICS_DATA_NOT_EXISTS("120001","直播统计数据尚未生成"),
    NO_CONF_PERMISSION("120002","没有权限"),
    REWARD_MAX_SIZE_LIMIT("120003","最多只能配100个奖品噢"),
    FILE_OVERSIZE("120004","文件太大了,请上传小于50兆的视频"),
    QUESTION_HAS_ALREADY_USED("120005","已有用户提了该问题,无法修改"),
    RESOURCE_HAS_ALREADY_USED("120006","已有用户领取了该资料,无法修改"),
    WELFARE_HAS_ALREADY_USED("120007","已有用户领取了该权益,无法修改"),
    CHOICE_QUESTION_HAS_ALREADY_USED("120008","已使用,无法修改"),
    LIVE_STARTED("120009","直播已开始，无法再进行修改"),
    LIVE_NOT_START("120014","非直播中不能修改直播介绍"),

    // 13 直播红包
    RED_PACKET_SAVE_OR_UPDATE_FAIL("130001","红包新增或更新失败"),
    RED_PACKET_MAX_AMOUNT_UPDATE_FAIL("130002","红包限额更新失败"),
    RED_PACKET_MAX_AMOUNT_NOT_FIND("130003","未查询到红包限额"),
    RED_PACKET_ALREADY_HELP("130004","已经帮别人助力过了"),
    RED_PACKET_CAN_NOT_HELP_SELF("130005","不能给自己助力哦"),
    RED_PACKET_START_EXIST("130006","开播红包尚未结束"),
    RED_PACKET_NOT_FIND("130007","红包不存在"),
    RED_PACKET_DELETE_FAIL("130008","红包删除失败"),

    RED_PACKET_LIVE_START_CAN_NOT_DELETE("130009","开播之后，不能删除"),
    RED_PACKET_CAN_NOT_UPDATE("130010","发布后不能更改"),
    RED_PACKET_AMOUNT_LIMIT("130011","金额超过限制"),
    RED_PACKET_BEFORE_HAS_NOT_END("130012","在本轮红包之前有未结束的红包"),
    RED_PACKET_UPDATE_STATUS_FAIL("130013","更改红包状态失败"),
    RED_PACKET_ALTER_START("130014","本轮红包已经发布过了"),

    // 14 直播权益
    WELFARE_HAS_RECEIVED("140001","当前权益已领取"),
    WELFARE_NOT_EXIST("140002","当前权益不存在"),
    WELFARE_NOT_IN_USE("140003","当前权益已下架"),
    COMPANY_WELFARE_CAN_NOT_DRAW("140004","公司权益无法领取"),
    LIVE_NOT_START_LOTTERY_NOT_FIND("140005","没有未发放的福利"),
    LIVE_START_LOTTERY_NOT_FIND("140006","没有发放的福利"),
    WELFARE_LAST_NOT_END("140007","上轮福利尚未结束"),
    WELFARE_UPDATE_STATUS_FAIL("140008","更改状态失败"),
    INVITATION_AGENT_NOT_FIND("140009","绑定代理人不存在"),
    RECEIVE_FAIL("140010","领取失败"),


    ;

    private String shortCode;
    private String desc;

    ErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }

    @Override
    public String getHost() {
        return "07";
    }

    @Override
    public String getShortCode() {
        return this.shortCode;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
