package cn.com.duiba.kjy.liveaward.center.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.liveaward.center.api.dto.lottery.LiveLotteryCollectDto;
import cn.com.duiba.kjy.liveaward.center.api.dto.lottery.LiveRewardLotteryRealResultDto;
import cn.com.duiba.kjy.liveaward.center.api.dto.lottery.LiveRewardLotteryResultDto;

import java.util.List;

/**
 * 直播抽奖
 * @author dugq
 * @date 2020-07-06
 */
@AdvancedFeignClient
public interface RemoteLiveRewardLotteryService {

    /**
     * 收集在线用户
     * @param list 用户信息
     */
    void collect(List<LiveLotteryCollectDto> list);

    /**
     * 预热抽奖，将用户添加到抽奖池中
     * @param list 用户信息
     */
    void preCollect(List<LiveLotteryCollectDto> list);

    /**
     * 执行抽奖任务
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @return 是否成功
     * @deprecated 请使用 asyncDrawAndSendMq
     */
    @Deprecated
    boolean drawAndSendWs(Long liveId, Long confId);

    /**
     * 异步执行抽奖任务
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @param topic 回调的mq的topic
     * @param tag 回调的mq的tag
     *            回调内容结构 {"liveId":1,"confId":2}
     */
    void asyncDrawAndSendMq(Long liveId, Long confId, String topic, String tag);

    /**
     * 获取真实中奖人数，从redis缓存查询
     *
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @return 真实中奖人数，注意：可为null，为null说明redis中没有值
     */
    Integer getLotteryCount(Long liveId, Long confId);

    /**
     * 获取真实中奖人列表，从redis缓存查询
     *
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @return 真实中奖人列表，注意：可为null，为null说明redis中没有值
     */
    List<LiveRewardLotteryRealResultDto> getRealResultList(Long liveId, Long confId);

    /**
     * 获取真实中奖人列表-分页，每页条数为1000，从redis缓存查询
     *
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @param pageIndex 页码
     * @return 真实中奖人列表，注意：可为null，为null说明redis中没有值
     */
    List<LiveRewardLotteryRealResultDto> getRealResultPage(Long liveId, Long confId, int pageIndex);

    /**
     * 获取中奖名单（包含马甲，最多200条），从redis缓存查询
     *
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @return 中奖名单，注意：可为null，为null说明redis中没有值
     */
    List<LiveRewardLotteryResultDto> getAllResultList(Long liveId, Long confId);

    /**
     * 获取中奖用户昵称名单（包含马甲，最多200条），从redis缓存查询
     *
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @return 中奖用户昵称名单，注意：可为null，为null说明redis中没有值
     */
    List<String> getAllResultNameList(Long liveId, Long confId);

}
