package cn.com.duiba.kjy.liveaward.center.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 直播红包-用于服务挂了人工启动各个环节
 * 业务方慎用！！！
 * @author dugq
 * @date 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteLiveRedFixService {

    /**
     * 开始收集用户信息
     * @param liveId 直播ID
     */
    void startCollect(Long liveId);

    /**
     * 计算哪些人中红包
     * @param liveId 直播ID
     * @param confId 红包ID
     */
    void compute(Long liveId, Long confId);

    /**
     * 停止领取
     * @param liveId 直播ID
     * @param confId 红包ID
     */
    void stopReceive(Long liveId, Long confId);

    /**
     * 补充马甲
     * @param liveId 直播ID
     * @param confId 红包ID
     */
    void addVestAndEnd(Long liveId, Long confId);
}
