package cn.com.duiba.kjy.liveaward.center.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.liveaward.center.api.dto.red.LiveRedResultDto;

import java.util.List;

/**
 * 直播红包
 * @author dugq
 * @date 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteLiveRedService {

    /**
     * 开始发红包
     * @param liveId 直播ID
     * @param confId 红包ID
     * @param liveUserId 直播用户ID
     * @return 是否成功
     */
    boolean start(Long liveId, Long confId, Long liveUserId);

    /**
     * 领取结果
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 领取结果列表
     */
    List<LiveRedResultDto> getResultList(Long liveId, Long confId);
}
