package cn.com.duiba.kjy.livecenter.api.param.clue;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播线索-观看记录
 * @author kjj mybatis generator 
 * @date 2020-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveClueVisitSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 1585360893790346L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 第一次进入时间
     */
    private Date firstStartTime;

    /**
     * 最近一次进入时间
     */
    private Date lastStartTime;

    /**
     * 最近一次退出时间
     */
    private Date lastEndTime;

    /**
     * 最后一次访问时长，单位秒
     */
    private Integer lastDuration;

    /**
     * 总访问时长，单位秒
     */
    private Integer duration;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}