package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveAdminDto;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveAdminInsertDto;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveAdminSearchParam;

import java.util.List;

/**
 * 直播公司管理员服务
 * @author 周舟
 * @date 2020-3-28 10:22:31
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyAdminService {

    /**
     * 列表查询
     * @param queryParam 查询参数
     * @return 直播公司管理员集合
     */
    List<LiveAdminDto> findList(LiveAdminSearchParam queryParam);

    /**
     * 保存直播公司管理员
     * @param dto 直播公司管理员
     * @return 主键，为0，说明新增失败
     */
    Long save(LiveAdminInsertDto dto);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 是否成功 1 成功 其他失败
     */
    Long deleteById(Long id);
    
}
