package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.LiveAgentInvitationDto;
import cn.com.duiba.kjy.livecenter.api.param.invitation.CreateNewAgentInvitationParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.CreateNewVisitorInvitationParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.LiveAgentInvitationSearchParam;

import java.util.List;

/**
 * 邀请客户服务类
 * @author 吴文哲
 * @date 2020-03-30 19:52
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentInvitationService {

    /**
     * 获取被邀请人的列表
     * @param param
     * @return
     */
    List<LiveAgentInvitationDto> getInvitedUserList(LiveAgentInvitationSearchParam param);
    /**
     * 新增绑定关系
     * @param param 参数
     * @return >0 绑定成功条数。正常 为1  0 发生未知错误  -1 绑定并发  -2 已经存在绑定关系  -3 参数错误。
     *
     */
    int insertAgentInvitation(CreateNewAgentInvitationParam param);

    /**
     * 新增访客邀请关系
     * @param param 访客信息
     * @return >0 绑定成功条数。正常 为1  0 发生未知错误  -1 绑定并发  -2 已经存在绑定关系  -3 参数错误。
     */
    int insertVisitorInvitation(CreateNewVisitorInvitationParam param);
}
