package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveAgentDto;

import java.util.List;

/**
 * 直播代理人rpc服务类
 * @author 吴文哲
 * @date 2020-03-30 21:00
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentService {


    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播公司团队
     */
    LiveAgentDto findById(Long id);

    /**
     * 根据主键id查找列表
     * @param ids
     * @return
     */
    List<LiveAgentDto> findByIds(List<Long> ids);

    /**
     * 根据团队id 统计
     * @param teamId
     * @return
     */
    Integer countByTeamId(Long teamId);


}
