package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveAdminDto;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyDto;
import cn.com.duiba.kjy.livecenter.api.dto.user.LiveUserDto;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveAdminSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.user.LiveUserSearchParam;

import java.util.List;

/**
 * 直播用户服务
 * @author 周舟
 * @date 2020-3-28 10:22:31
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveUserService {

    /**
     * 列表查询
     * @param queryParam 查询参数
     * @return 直播用户集合
     */
    List<LiveUserDto> findList(LiveUserSearchParam queryParam);

    /**
     * 保存更新直播用户
     * @param dto 直播用户
     * @return 主键，为0，说明新增失败
     */
    Long saveAndUpdate(LiveUserDto dto);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播用户
     */
    LiveUserDto findById(Long id);


    /**
     * 根据id查询
     * @param ids 主键id列表
     * @return 直播用户
     */
    List<LiveUserDto> findByIds(List<Long> ids);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 是否成功 1 成功 其他失败
     */
    Long deleteById(Long id);
    
}
