package cn.com.duiba.kjy.livecenter.api.util;

import cn.com.duiba.wolf.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.util.Base64;

/**
 * Created by dugq on 2019-10-23.
 *
 * 把ID转换后通过base64编码得出来的值
 * 规律： 以Kj2 开头。第四位为base64结尾'='的个数。避免url encoding
 *       数字部分利用二进制左移3位，后三位补1 把数字变换掉，再base64转码。支持最大值为 2^(64-4)
 * 兼容：旧版本以kjj开头 第四位取原数字第一位补充。 加密已删除，揭秘通过kjj 和 kj2 区分
 * 修改原因： 旧版本太长， 且要处理URL编码问题导致多了一次转换16进制。 加密的主要方案在于 数字左移和补最高位，鉴于base64的高效，所以使用base64encode来美化ID
 *
 * base64加密效率： 加密 1 - 2千万  1s以内完成
 */
@Slf4j
public class IdMakeUtil {

    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();

    private static final String PREFIX = "Kj2";

    private IdMakeUtil(){}

    public static String encodingId(Long id) {
        id = (id << 3) ^ 7;
        String encode = encoder.encodeToString(Long.toString(id).getBytes());
        String replace = encode.replace("=", "");
        return PREFIX + (encode.length() - replace.length()) + replace;
    }

    public static Long decodingId(String encode) {
        if (StringUtils.isBlank(encode)) {
            return null;
        }
        try {
            StringBuilder substring = new StringBuilder(encode.substring(4));

            String decode = new String(decoder.decode(substring.toString()));
            return Long.valueOf(decode) >> 3;
        } catch (Exception e) {
            log.info("decode ID error; id = {}",encode,e);
            return null;
        }
    }

    public static void main(String[] args) {
        String s = encodingId(1L);
        System.out.println(DateUtils.getMinuteDate("2020-03-31 22:00").getTime());
        System.out.println(s);
        System.out.println(decodingId(s));
    }

}
