package cn.com.duiba.kjy.livecenter.api.enums.clue;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * @author 吴文哲
 * @date 2020-04-05 15:18
 **/
public enum LiveClueRewardTypeEnums {

    MATERIAL(1,"资料"),
    SUBSCRIBE(2,"关注直播间"),
    ACCUMULATE_READ(3,"累计观看"),
    FRIEND_INVITE(4,"邀请好友"),
    FREE_GET(5,"免费领"),
    GRAB_WELFARE(6,"抢权益"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    LiveClueRewardTypeEnums(Integer type ,String desc){
        this.type  = type;
        this.desc  = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 权益类型
     */
    private static List<Integer> welfareTypes = Lists.newArrayList();

    static {
        welfareTypes.addAll(Lists.newArrayList(SUBSCRIBE.getType(),ACCUMULATE_READ.getType(),FRIEND_INVITE.getType(),FREE_GET.getType(),GRAB_WELFARE.getType()));
    }

    public static List<Integer> getWelfareTypes() {
        return welfareTypes;
    }
}
