package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.bean.Page;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyDetailDto;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyDto;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveCompanyClueCollectorParam;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveCompanySearchParam;

import java.util.List;

/**
 * 直播公司服务
 * @author 周舟
 * @date 2020-3-28 10:22:23
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyService {

    /**
     * 分页查询
     * @param queryParam 分页查询参数
     * @return 直播公司集合
     */
    Page<LiveCompanyDto> findPageList(LiveCompanySearchParam queryParam);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播公司
     */
    LiveCompanyDto findById(Long id);

    /**
     * 根据主键查询详情（包含统计数据）
     * @param id 主键
     * @return 公司详情
     */
    LiveCompanyDetailDto findDetailById(Long id);

    /**
     * 保存更新直播公司
     * @param dto 直播公司
     * @return 主键，为0，说明新增失败
     */
    Long saveAndUpdate(LiveCompanyDto dto);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 直播公司
     */
    Integer deleteById(Long id);

    /**
     * 批量查询
     * @param ids
     * @return
     */
    List<LiveCompanyDto> findByIds(List<Long> ids);

    /**
     * 保存直播公司线索收集员信息
     * @param param
     * @return
     */
    Boolean saveClueCollector4Kjj(LiveCompanyClueCollectorParam param);

    /**
     * 根据线索员id 查询公司列表
     * @param agentId
     * @return
     */
    List<LiveCompanyDto> findByClueCollectorId(Long agentId);
    
}
