package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveRedPacketReceiveDto;
import cn.com.duiba.kjy.livecenter.api.dto.red.LiveConfRedPacketDto;
import cn.com.duiba.kjy.livecenter.api.dto.red.LiveStatisticsRedPacketDto;
import cn.com.duiba.kjy.livecenter.api.dto.red.LiveVisitorHelpDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveRedPacketReceiveSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.red.LiveRedPacketReceiveParam;
import cn.com.duiba.kjy.livecenter.api.param.red.LiveVisitorHelpSearchParam;

import java.util.List;

/**
 * 直播红包相关
 * @author lizhi
 * @date 2020/4/3 1:33 PM
 */
@AdvancedFeignClient
public interface RemoteLiveRedPacketService {

    /**
     * 新增或更新开播红包
     * @param dto 红包信息
     * @return 红包主键
     */
    Long saveOrUpdateStartLive(LiveConfRedPacketDto dto);

    /**
     * 新增或更新实时红包
     * @param dto 红包信息
     * @return 红包主键
     */
    Long saveOrUpdateRealTime(LiveConfRedPacketDto dto);

    /**
     * 更新开播红包开抢时间
     * @param liveId 直播ID
     * @return 执行结果
     */
    int updateStartLiveRedPacketTime(Long liveId);

    /**
     * 根据直播ID查询
     * @param liveId 直播ID
     * @return 直播配置-红包统计数据
     */
    LiveStatisticsRedPacketDto findStatisticsByLiveId(Long liveId);

    /**
     * 从缓存中查询开播红包
     * @param liveId 查询条件
     * @return 直播配置-开播红包
     */
    LiveConfRedPacketDto findStartLiveRedPacketFromCache(Long liveId);

    /**
     * 从缓存中查询未领取完的实时红包
     * @param liveId 查询条件
     * @return 直播配置-开播红包
     */
    LiveConfRedPacketDto findUnfinishedRealTimeRedPacketFromCache(Long liveId);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播配置-红包相关配置
     */
    LiveConfRedPacketDto findById(Long id);

    /**
     * 保存助力信息
     * @param dto 助力信息
     * @return 执行结果
     */
    int saveHelp(LiveVisitorHelpDto dto);

    /**
     * 分页查询助力关系
     * @param param 分页参数
     * @return 直播-助力关系集合
     */
    List<LiveVisitorHelpDto> findHelpPage(LiveVisitorHelpSearchParam param);

    /**
     * 领取红包
     * @param param 领红包参数
     * @return 领红包记录
     */
    LiveRedPacketReceiveDto receiveRedPacket(LiveRedPacketReceiveParam param);

    /**
     * 根据领取记录ID，查询红包结果
     * @param receiveId 领取记录ID
     * @return 领取结果
     */
    LiveRedPacketReceiveDto findReceiveById(Long receiveId);

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播红包领取记录集合
     */
    List<LiveRedPacketReceiveDto> findReceivePage(LiveRedPacketReceiveSearchParam param);
}
