package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.aliyunlive.StreamUrlDto;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveConfRewardPkDto;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveDetailDto;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveDto;
import cn.com.duiba.kjy.livecenter.api.param.live.LiveSearchParam;

import java.util.List;

/**
 * 直播
 * @author lizhi
 * @date 2020/3/30 2:57 PM
 */
@AdvancedFeignClient
public interface RemoteLiveService {

    /**
     *  阿里云回调专用
     *  根据阿里云流名称，获取直播
     * @param streamName 阿里云流名称
     * @return
     */
    LiveDto getLiveByAliyunStream(String streamName);

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播集合
     */
    List<LiveDto> selectPage(LiveSearchParam param);

    /**
     * 从缓存中查询直播详情，包含配置信息
     * @param liveId 直播ID
     * @return 直播详情，包含配置信息
     */
    LiveDetailDto findLiveDetailFromCache(Long liveId);

    /**
     * 新增或更新直播
     * @param dto 直播信息
     * @return 直播ID
     */
    Long saveOrUpdateLive(LiveDto dto);

    /**
     * 修改直播互动红包限额
     * @param liveId 直播ID
     * @param amount 互动红包限额
     * @return 结果
     */
    boolean saveOrUpdateInteractionAmount(Long liveId, Integer amount);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播
     */
    LiveDto findById(Long id);

    /**
     * 更新直播状态
     * @param liveId 直播ID
     * @param liveStatus 直播状态
     * @return 更新结果
     */
    int updateStatus(Long liveId, Integer liveStatus);

    /**
     * 新增或更新pk奖励
     * @param liveId 直播ID
     * @param pkDtoList pk奖励集合
     * @return 执行结果
     */
    int batchSaveOrUpdatePk(Long liveId, List<LiveConfRewardPkDto> pkDtoList);

    /**
     * 根据直播ID和类型查询
     * @param liveId 直播ID，不可为空
     * @param rewardType 奖励类型，1-个人，2-团队，可为空
     * @return 直播配置-pk奖励集合
     */
    List<LiveConfRewardPkDto> findByLiveIdAndType(Long liveId, Integer rewardType);

    /**
     * 从缓存获取直播的推流信息
     * @param liveId 直播主键
     * @return 推流信息
     */
    StreamUrlDto getLivePushInfoFromCache(Long liveId);

    /**
     * 从缓存获取直播的拉流信息
     * @param liveId 直播主键
     * @return 拉流信息
     */
    List<StreamUrlDto> getLivePullInfoFromCache(Long liveId);
}
