package cn.com.duiba.kjy.livecenter.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播配置-红包相关配置
 * @author kjj mybatis generator 
 * @date 2020-04-02
 */
@Data
public class LiveConfRedPacketDto implements Serializable {
     
    private static final long serialVersionUID = 158581531908280L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 红包金额
     */
    private Integer amount;

    /**
     * 红包数量
     */
    private Integer num;

    /**
     * 红包剩余金额
     */
    private Integer surplusAmount;

    /**
     * 红包剩余数量
     */
    private Integer surplusNum;

    /**
     * 需要邀请人数
     */
    private Integer invitationNum;

    /**
     * 多少分钟之后开抢
     */
    private Integer afterMin;

    /**
     * 开抢时间
     */
    private Date startTime;

    /**
     * 红包类型：1-开播，2-发红包
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedPacketTypeEnum
     */
    private Integer redType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}