package cn.com.duiba.kjy.livecenter.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播
 * @author kjj mybatis generator 
 * @date 2020-03-28
 */
@Data
public class LiveDto implements Serializable {
     
    private static final long serialVersionUID = 15853608937785612L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 宣传海报
     */
    private String posterUrl;

    /**
     * 宣传视频
     */
    private String videoUrl;

    /**
     * 直播标题
     */
    private String title;

    /**
     * 直播流ID
     */
    private Long streamId;

    /**
     * 预告时间
     */
    private Date noticeTime;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 直播状态：1-未开始，2-直播中，3-断网，4-直播结束
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveStatusEnum
     */
    private Integer liveStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}